<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UploadedExam extends Model
{
    use HasFactory;

    public function exam()
    {
        return $this->belongsTo(Exam::class,'exam_id');
    }

    public function subscribe()
    {
        return $this->belongsTo(StudentSubscribe::class,'subscribe_id');
    }

    public function answers()
    {
        return $this->hasMany(StudentAnswer::class,'uploaded_exam_id');
    }
}
